import pandas as pd, numpy as np, sys

CSV = "data/results/vol4_wilson_loop_pipeline_crossover_analysis/crossover_summary.csv"
df = pd.read_csv(CSV)

for col in ("L","gauge","b","sigma_c"):
    if col not in df.columns:
        print("Missing column:", col); sys.exit(1)
if "sigma_c_err" not in df.columns:
    df["sigma_c_err"] = 0.0

df["L"] = df["L"].astype(int)

def check_monotone_with_err(group):
    g = group.sort_values("b")
    y = g["sigma_c"].to_numpy()
    e = g["sigma_c_err"].fillna(0.0).to_numpy()
    for i in range(len(y)-1):
        # Expect non-increasing with b; allow for 1σ combined tolerance
        tol = np.sqrt(e[i]**2 + e[i+1]**2) + 1e-6
        if y[i] < y[i+1] - tol:
            return False
    return True

def ratio_with_err(df, gauge, b):
    sub = df[(df["gauge"]==gauge) & (df["b"]==b)]
    if not ({16,20} <= set(sub["L"].unique())): return None
    s16 = sub[sub["L"]==16]["sigma_c"].mean()
    e16 = sub[sub["L"]==16]["sigma_c_err"].mean()
    s20 = sub[sub["L"]==20]["sigma_c"].mean()
    e20 = sub[sub["L"]==20]["sigma_c_err"].mean()
    if s16 <= 0: return None
    r = s20 / s16
    dr = np.sqrt( (e20/s16)**2 + (s20*e16/s16**2)**2 )
    return r, dr

fails = []
for (L,g), sub in df.groupby(["L","gauge"]):
    if not check_monotone_with_err(sub):
        fails.append((int(L), g))

print("\nMonotone wrt b (within errors):", "PASS" if not fails else f"CHECK: {fails}")

print("L-scaling ratios (L=20 / L=16) per (gauge,b):")
band = (0.4, 0.7)
ok_ratios = True
for g in sorted(df["gauge"].unique()):
    for b in sorted(df["b"].unique()):
        rg = ratio_with_err(df, g, b)
        if rg is None: continue
        r, dr = rg
        within = not (r+dr < band[0] or r-dr > band[1])  # 1σ overlap with target band
        ok_ratios &= within
        tag = "OK " if within else "CHK"
        print(f"  {g}  b={b}:  {r:.3f} ± {dr:.3f}  (target {band[0]}–{band[1]})  {tag}")

print("\nOVERALL:",
      "PASS — crossover proxy consistent with expected trends."
      if not fails and ok_ratios else
      "CHECK — investigate groups listed above.")
